/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.hud;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.framework.objects.MouseButton;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.render.ChatRenderEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.HudRenderEvent;
import Krasnodar.rockstarnew.systems.event.impl.window.ChatClickEvent;
import Krasnodar.rockstarnew.systems.event.impl.window.ChatKeyPressEvent;
import Krasnodar.rockstarnew.systems.event.impl.window.ChatReleaseEvent;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.systems.modules.modules.visuals.Nametags;
import Krasnodar.rockstarnew.systems.notifications.NotificationType;
import Krasnodar.rockstarnew.ui.components.animated.AnimatedText;
import Krasnodar.rockstarnew.ui.components.popup.Popup;
import Krasnodar.rockstarnew.ui.hud.Grid;
import Krasnodar.rockstarnew.ui.hud.HudElement;
import Krasnodar.rockstarnew.ui.hud.HudHistoryManager;
import Krasnodar.rockstarnew.ui.hud.HudList;
import Krasnodar.rockstarnew.ui.hud.impl.Effects;
import Krasnodar.rockstarnew.ui.hud.impl.KeyBinds;
import Krasnodar.rockstarnew.ui.hud.impl.ScoreboardHud;
import Krasnodar.rockstarnew.ui.hud.impl.StaffList;
import Krasnodar.rockstarnew.ui.hud.impl.TargetHud;
import Krasnodar.rockstarnew.ui.hud.impl.island.DynamicIsland;
import Krasnodar.rockstarnew.ui.hud.inline.impl.PlayerElement;
import Krasnodar.rockstarnew.ui.hud.inline.impl.WorldElement;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.game.cursor.CursorType;
import Krasnodar.rockstarnew.utility.game.cursor.CursorUtility;
import Krasnodar.rockstarnew.utility.gui.GuiUtility;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import Krasnodar.rockstarnew.utility.interfaces.IScaledResolution;
import Krasnodar.rockstarnew.utility.render.RenderUtility;
import Krasnodar.rockstarnew.utility.render.Utils;
import Krasnodar.rockstarnew.utility.time.Timer;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_408;
import ru.kotopushka.compiler.sdk.annotations.CompileBytecode;

public class Hud
implements IMinecraft,
IScaledResolution {
    private final List<HudElement> elements = new ArrayList<HudElement>();
    private final List<Popup> popups = new ArrayList<Popup>();
    public DynamicIsland island;
    private final HudHistoryManager historyManager = new HudHistoryManager();
    private final Grid grid = new Grid();
    private String desc = "";
    private AnimatedText descText;
    private final Timer timer = new Timer();
    private final EventListener<HudRenderEvent> onHud = event -> {
        UIContext context = UIContext.of(event.getContext(), Hud.mc.field_1755 == null ? -1 : (int)GuiUtility.getMouse().method_32118(), Hud.mc.field_1755 == null ? -1 : (int)GuiUtility.getMouse().method_32119(), class_310.method_1551().method_61966().method_60637(false));
        if (this.descText == null) {
            this.descText = new AnimatedText(Fonts.REGULAR.getFont(10.0f), 10.0f, 300L, Easing.BAKEK).centered();
        }
        this.desc = "";
        this.grid.draw(context);
        this.grid.update();
        for (HudElement element : this.elements) {
            element.render(context);
            if (!(element.getSelecting().getValue() >= 0.0f)) continue;
            float anim = element.getAnimation().getValue() * element.getVisible().getValue();
            float scale = 0.5f + anim * 0.5f - 0.05f * element.getSelecting().getValue();
            element.getLoadingAnim().setDuration(1500L);
            element.getLoadingAnim().update(1.0f);
            if (element.getLoadingAnim().getValue() == 1.0f) {
                element.getLoadingAnim().setValue(0.0f);
            }
            RenderUtility.scale(context.method_51448(), element.getX() + element.getWidth() / 2.0f, element.getY() + element.getHeight() / 2.0f, scale);
            context.drawLoadingRect(element.getX(), element.getY(), element.getWidth(), element instanceof HudList ? Math.max(20.0f, element.getHeight()) : element.getHeight(), element.getLoadingAnim().getValue() * 2.2f - 0.5f, BorderRadius.all(element instanceof DynamicIsland ? 7.0f : 6.0f), ColorRGBA.WHITE.withAlpha(100.0f * element.getSelecting().getValue()));
            RenderUtility.end(context.method_51448());
        }
        this.descText.pos(sr.getScaledWidth() / 2.0f, 30.0f);
        if (!this.desc.contains(".description")) {
            this.descText.update(this.desc);
            this.descText.render(context);
        }
        for (Popup popup : this.popups) {
            if (Hud.mc.field_1755 instanceof class_408) continue;
            popup.setShowing(false);
        }
        if (!(Hud.mc.field_1755 instanceof class_408)) {
            CursorUtility.set(CursorType.DEFAULT);
        }
        this.popups.removeIf(popupx -> popupx.getAnimation().getValue() == 0.0f && !popupx.isShowing());
    };
    private final EventListener<ChatRenderEvent> onPostHud = event -> {
        UIContext context = UIContext.of(event.getContext(), Hud.mc.field_1755 == null ? -1 : (int)GuiUtility.getMouse().method_32118(), Hud.mc.field_1755 == null ? -1 : (int)GuiUtility.getMouse().method_32119(), class_310.method_1551().method_61966().method_60637(false));
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 2000.0f);
        for (Popup popup : this.popups) {
            if (popup.getY() + popup.getHeight() > sr.getScaledHeight()) {
                popup.setY(sr.getScaledHeight() - 10.0f - popup.getHeight());
            }
            popup.render(context);
        }
        context.method_51448().method_22909();
    };
    private final EventListener<ChatKeyPressEvent> onKeyPress = event -> {
        int modifiers = event.getModifiers();
        int keyCode = event.getKeyCode();
        if (keyCode == 90 && (modifiers & 2) != 0) {
            Rockstar.getInstance().getHud().getHistoryManager().undo();
        } else if (keyCode == 89 && (modifiers & 2) != 0) {
            Rockstar.getInstance().getHud().getHistoryManager().redo();
        }
    };
    private final EventListener<ChatClickEvent> onClick = event -> {
        for (class_1297 entity : Rockstar.getInstance().getModuleManager().getModule(Nametags.class).getEntityList()) {
            class_243 pos = Utils.getInterpolatedPos(entity, 1.0f).method_1031(0.0, entity.method_5829().method_17940() + 0.5, 0.0);
            class_241 screenPos = Utils.worldToScreen(pos);
            if (screenPos == null || entity.method_5864() != class_1299.field_6097 || !this.handleClick((ChatClickEvent)event, entity, screenPos)) continue;
            return;
        }
        for (Popup popup : this.popups) {
            popup.onMouseClicked(event.getX(), event.getY(), MouseButton.fromButtonIndex(event.getButton()));
            if (popup.isHovered(event.getX(), event.getY())) {
                return;
            }
            popup.setShowing(false);
        }
        for (HudElement element : this.elements) {
            element.onMouseClicked(event.getX(), event.getY(), MouseButton.fromButtonIndex(event.getButton()));
            if ((!element.isHovered(event.getX(), event.getY()) || !element.isShowing()) && !element.isDragging()) continue;
            return;
        }
        if (event.getButton() == 1 && !this.disabledElements().isEmpty()) {
            Popup popup = new Popup(event.getX(), event.getY(), 90.0f, 6.0f).title(Localizator.translate("whatadd")).separator();
            for (HudElement elementx : this.disabledElements()) {
                popup.button(Localizator.translate(elementx.getName()), elementx.getIcon(), popup1 -> {
                    elementx.pos(event.getX(), event.getY());
                    elementx.setShowing(true);
                    popup1.setShowing(false);
                    Rockstar.getInstance().getFileManager().writeFile("client");
                });
            }
            this.popups.add(popup);
        } else if (event.getButton() == 1 && this.disabledElements().isEmpty() && this.timer.finished(600L)) {
            Rockstar.getInstance().getNotificationManager().addNotificationOther(NotificationType.ERROR, "\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u043d\u0435\u0442", "\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0437\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0438\u0441\u044c, \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u0447\u0435\u0433\u043e");
            this.timer.reset();
        }
    };
    private final EventListener<ChatReleaseEvent> onRelease = event -> {
        for (Popup popup : this.popups) {
            popup.onMouseReleased(event.getX(), event.getY(), MouseButton.fromButtonIndex(event.getButton()));
            if (!popup.isHovered(event.getX(), event.getY())) continue;
            return;
        }
        for (HudElement element : this.elements) {
            element.onMouseReleased(event.getX(), event.getY(), MouseButton.fromButtonIndex(event.getButton()));
        }
    };

    @CompileBytecode
    private void initialize() {
        Rockstar.getInstance().getEventManager().subscribe(this);
        this.island = new DynamicIsland();
        this.elements.addAll(List.of(new Effects(), new KeyBinds(), new TargetHud(), this.island, new WorldElement(), new PlayerElement(), new ScoreboardHud(), new StaffList()));
    }

    public Hud() {
        this.initialize();
    }

    public List<HudElement> enabledElements() {
        return this.elements.stream().filter(HudElement::isShowing).toList();
    }

    public List<HudElement> disabledElements() {
        return this.elements.stream().filter(element -> !element.isShowing()).toList();
    }

    public <T extends HudElement> T getElementByName(String name) {
        return (T)((HudElement)this.elements.stream().filter(element -> element.getName().equalsIgnoreCase(name)).findFirst().orElse(null));
    }

    private boolean handleClick(ChatClickEvent event, class_1297 entity, class_241 screenPos) {
        float distance = entity.method_5739((class_1297)Hud.mc.field_1724);
        float scale = class_3532.method_15363((float)(1.0f - distance / 20.0f), (float)0.5f, (float)1.0f);
        class_2561 displayName = Nametags.displayName(entity);
        float textWidth = Fonts.MEDIUM.getFont(11.0f).width(displayName);
        float textHeight = Fonts.MEDIUM.getFont(11.0f).height();
        float rectWidth = textWidth + 5.0f;
        float rectHeight = textHeight + 6.0f;
        float rectOffsetX = -textWidth / 2.0f - 3.0f;
        float rectOffsetY = 2.0f;
        float scaledRectWidth = rectWidth * scale;
        float scaledRectHeight = rectHeight * scale;
        float scaledRectX = screenPos.field_1343 + rectOffsetX * scale;
        float scaledRectY = screenPos.field_1342 + rectOffsetY * scale;
        return GuiUtility.isHovered((double)scaledRectX, (double)scaledRectY, (double)scaledRectWidth, (double)scaledRectHeight, event.getX(), event.getY());
    }

    @Generated
    public List<HudElement> getElements() {
        return this.elements;
    }

    @Generated
    public List<Popup> getPopups() {
        return this.popups;
    }

    @Generated
    public DynamicIsland getIsland() {
        return this.island;
    }

    @Generated
    public HudHistoryManager getHistoryManager() {
        return this.historyManager;
    }

    @Generated
    public Grid getGrid() {
        return this.grid;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public AnimatedText getDescText() {
        return this.descText;
    }

    @Generated
    public Timer getTimer() {
        return this.timer;
    }

    @Generated
    public EventListener<HudRenderEvent> getOnHud() {
        return this.onHud;
    }

    @Generated
    public EventListener<ChatRenderEvent> getOnPostHud() {
        return this.onPostHud;
    }

    @Generated
    public EventListener<ChatKeyPressEvent> getOnKeyPress() {
        return this.onKeyPress;
    }

    @Generated
    public EventListener<ChatClickEvent> getOnClick() {
        return this.onClick;
    }

    @Generated
    public EventListener<ChatReleaseEvent> getOnRelease() {
        return this.onRelease;
    }

    @Generated
    public void setDesc(String desc) {
        this.desc = desc;
    }
}

